package com.burhanstore.neonbubblequest.Utils.network


import android.util.Log
import com.google.gson.JsonObject
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.launch

object AppNetworkAdapter {

    interface ResponseHandler {
        fun onSuccess(response: JsonObject?)
        fun onError(code: Int, message: String?)
        fun onException(exception: Exception)
    }

    fun sendRequest(
        scope: CoroutineScope, // Pass activity.lifecycleScope
        data: JsonObject,
        handler: ResponseHandler
    ) {

        Log.e("app run netowk", data.toString())
        scope.launch {
            try {
                val response = RetrofitClient.api.sendJson(data)
                if (response.isSuccessful) {
                    handler.onSuccess(response.body())
                } else {
                    handler.onError(
                        response.code(),
                        response.errorBody()?.string()
                    )
                }
            } catch (e: Exception) {
                handler.onException(e)
            }
        }
    }
}
